using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace IndianHealthService.BMXNet.WinForm.Forms
{
    internal partial class ExceptionMessageDialog : System.Windows.Forms.Form
    {
        public ExceptionMessageDialog()
        {
            InitializeComponent();
        }

        private Exception _problem = null;

        public Exception Problem
        {
            get { return _problem; }
            set { _problem = value; }
        }


        private void CfShowExceptionDialog_Load(object sender, EventArgs e)
        {
            //this.Problem.Data
            //this.Problem.InnerException
            //this.Problem.Message
            //this.Problem.Source
            //this.Problem.StackTrace
            this.stackTraceTextBox.Text = this.Problem.StackTrace;
            this.exceptionTextBox.Text = this.Problem.Message;

            this.innerExceptionButton.Enabled = this.Problem.InnerException != null;

        }

        private void copyButton_Click(object sender, EventArgs e)
        {
    
        }

        private void innerExceptionButton_Click(object sender, EventArgs e)
        {
            ExceptionMessageDialog.SafeShow(this.Text, this.Problem.InnerException);

        }
        internal static void MessageBox(string aTitle, string aBody, Exception anException)
        {
            //Show a message box with "Details..." buttons

            if (anException == null)
                return;

            ExceptionMessageDialog dialog = new ExceptionMessageDialog();
            dialog.Text = aTitle ?? dialog.Text;
            dialog.Problem = anException;
            dialog.ShowDialog();
        }

        internal static void SafeShow(string aTitle, Exception anException)
        {
            if (anException == null)
                return;

            ExceptionMessageDialog dialog = new ExceptionMessageDialog();
            dialog.Text = aTitle ?? dialog.Text;
            dialog.Problem = anException;
            dialog.ShowDialog();
        }
    }
}